$(function() {
    
    // Form validation via plugin
    var submitMessage     = $('#submit-message'),
        messageContainer  = submitMessage.find('span'),
        loading           = $('#loading');
        
    function showMessage(message, classAttr) {
        messageContainer.text(message)
        messageContainer.attr('class', classAttr);
    }
    
        
    $('#contact-form').validate({        
               
        // Override to submit the form via ajax
        submitHandler: function(form) {
            var options = {
                beforeSubmit: function() {
                    loading.show();
                },
                success: function() {
                    showMessage('Gracias, Su mail ha sido enviado', 'success');
                    form.reset();
                    loading.hide();
                },
                error: function() {
                    showMessage('Lo siento, su mail no ha sido enviado. Intentelo nuevamente', 'failure');
                    loading.hide();
                }
            };
            $(form).ajaxSubmit(options);
        },
        invalidHandler: function() {
            showMessage('Hubo un problema con la comunicación. Intente más tarde.', 'failure');
        }
    });
});
